#ifndef _CONFIG_
#define _CONFIG_
typedef struct Controls Controls;
#include "common.h"
extern char const * VERSION;
extern bool global_can_enable_editor;
extern bool global_use_touch_input;
enum {
    FoundNothing,
    FoundButton,
    FoundAxis
};
enum {
    ControlNone,
    ControlLeft,
    ControlRight,
    ControlUp,
    ControlDown,
    ControlJump,
    ControlMenu,
    ControlUnused,
    ControlCount
};
struct Controls {
    int c [ControlCount] [3] /* key alt-key alt-key-2 */;
    int down [ControlCount];
    float strength [ControlCount];
    int pressed [ControlCount];
    int axis [ControlCount] [3] /* number, threshold (+/-) */;
    float detection [LandJoystickAxesCount];
    float zero [LandJoystickAxesCount];
    int button [ControlCount];
};
extern Controls controls;
void config_controls_read(void);
void config_check_controls(Application * a);
int config_joystick_control(int control, int progress);
void config_print_controls(LandFile * f);
void config_read_controls(str row);
str control_name(int c);
#endif
